string GetDescription()
{
	return "Creates a random melody line with repetitve rythm and cenetered aroun the tonic of the chord. \nLast bar gets an ending (single note)";
}

void Render(RenderPart @p)
{
	double speed = 2;
	
	int vel = 125;
	
	int pyk = 0;
	
	int old_harm = 0;
	
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		pyk = 0;
		for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=speed)
		{
			if (p.GetUniquePart().GetMetrum() - m < speed)
			{
				Time t = CreateTime(i,m);	
				int harm = p.GetHarmonic(t);
				old_harm = harm;
				Time t2 = CreateTime(i, p.GetUniquePart().GetMetrum());
				p.AddNote(t, t2, p.GetHarmonicEventPitch( harm,0) , RndInt(vel-15,vel));	
			}
			else
			{
				
				Time t = CreateTime(i,m);	
				int harm = p.GetHarmonic(t);
				
				if (old_harm != harm)
				{
					pyk = 0;
					old_harm = harm;	
				}
				
				int off = 0;
				if (pyk == 0) pyk = 1;
				else { off = 3; pyk = 0; }
					
				Time t2 = CreateTime(i, m + speed * 0.70 );
				p.AddNote(t, t2,  p.AlignPitch(p.GetHarmonicEventPitch( harm,0),-off) , RndInt(vel-15,vel));	
				
				t = CreateTime(i,m+speed * 0.75);	
				harm = p.GetHarmonic(t);	
				t2 = CreateTime(i, m + speed * 0.95 );
				p.AddNote(t, t2, p.AlignPitch(p.GetHarmonicEventPitch( harm,0),-off) , RndInt(vel-15,vel));	
				
			}
			
			pyk++;
		}	
	}
}